/**
 * Adds support for confirmation via JS modal for some management actions at the Manage policies page.
 *
 * @module      tool_policy/managedocsactions
 * @copyright   2018 David Mudrák <david@moodle.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_policy/managedocsactions",["jquery","core/log","core/config","core/str","core/modal_factory","core/modal_events"],(function($,Log,Config,Str,ModalFactory,ModalEvents){var ACTION_LINKS="[data-action]",ACTION_MAKE_CURRENT='[data-action="makecurrent"]',ACTION_INACTIVATE='[data-action="inactivate"]',ACTION_DELETE='[data-action="delete"]';function ManageDocsActions(base){this.base=base,this.initEvents()}return ManageDocsActions.prototype.initEvents=function(){this.base.on("click",ACTION_LINKS,(function(e){e.stopPropagation();var promise,strings,link=$(e.currentTarget);if(link.is(ACTION_MAKE_CURRENT))promise=Str.get_strings([{key:"activating",component:"tool_policy"},{key:"activateconfirm",component:"tool_policy",param:{name:link.closest("[data-policy-name]").attr("data-policy-name"),revision:link.closest("[data-policy-revision]").attr("data-policy-revision")}},{key:"activateconfirmyes",component:"tool_policy"}]);else if(link.is(ACTION_INACTIVATE))promise=Str.get_strings([{key:"inactivating",component:"tool_policy"},{key:"inactivatingconfirm",component:"tool_policy",param:{name:link.closest("[data-policy-name]").attr("data-policy-name"),revision:link.closest("[data-policy-revision]").attr("data-policy-revision")}},{key:"inactivatingconfirmyes",component:"tool_policy"}]);else{if(!link.is(ACTION_DELETE))return void Log.error("unknown action type detected","tool_policy/managedocsactions");promise=Str.get_strings([{key:"deleting",component:"tool_policy"},{key:"deleteconfirm",component:"tool_policy",param:{name:link.closest("[data-policy-name]").attr("data-policy-name"),revision:link.closest("[data-policy-revision]").attr("data-policy-revision")}},{key:"delete",component:"core"}])}e.preventDefault(),promise.then((function(strs){return strings=strs,ModalFactory.create({title:strings[0],body:strings[1],type:ModalFactory.types.SAVE_CANCEL})})).then((function(modal){return modal.setSaveButtonText(strings[2]),modal.getRoot().on(ModalEvents.save,(function(){window.location.href=link.attr("href")+"&sesskey="+Config.sesskey+"&confirm=1"})),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()})),modal.show(),!0})).catch((function(e){return Log.error(e),!1}))}))},{init:function(baseid){var base=$(document.getElementById(baseid));if(base.length)return new ManageDocsActions(base);throw new Error("managedocsactions: Invalid base element identifier")}}}));

//# sourceMappingURL=managedocsactions.min.js.map