/**
 * This module depends on the real jquery - and returns the non-global version of it.
 *
 * @module     core_customfield/form
 * @copyright  2018 Toni Barbera
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_customfield/form",["jquery","core/str","core/notification","core/ajax","core/templates","core/sortable_list","core/pending","core/inplace_editable"],(function($,Str,Notification,Ajax,Templates,SortableList,Pending){var confirmDelete=function(id,type,component,area,itemid){var pendingPromise=new Pending("core_customfield/form:confirmDelete");Str.get_strings([{key:"confirm"},{key:"confirmdelete"+type,component:"core_customfield"},{key:"yes"},{key:"no"}]).then((function(s){Notification.confirm(s[0],s[1],s[2],s[3],(function(){var pendingDeletePromise=new Pending("core_customfield/form:confirmDelete"),func="field"===type?"core_customfield_delete_field":"core_customfield_delete_category";Ajax.call([{methodname:func,args:{id:id}},{methodname:"core_customfield_reload_template",args:{component:component,area:area,itemid:itemid}}])[1].then((function(response){return Templates.render("core_customfield/list",response)})).then((function(html,js){return Templates.replaceNode($('[data-region="list-page"]'),html,js),null})).then(pendingDeletePromise.resolve).catch(Notification.exception)}))})).then(pendingPromise.resolve).catch(Notification.exception)};return{init:function(){var mainlist=$("#customfield_catlist"),component=mainlist.attr("data-component"),area=mainlist.attr("data-area"),itemid=mainlist.attr("data-itemid");$("[data-role=deletefield]").on("click",(function(e){confirmDelete($(this).attr("data-id"),"field",component,area,itemid),e.preventDefault()})),$("[data-role=deletecategory]").on("click",(function(e){confirmDelete($(this).attr("data-id"),"category",component,area,itemid),e.preventDefault()})),$("[data-role=addnewcategory]").on("click",(function(){!function(component,area,itemid){var categoryid,pendingPromise=new Pending("core_customfield/form:confirmDelete"),promises=Ajax.call([{methodname:"core_customfield_create_category",args:{component:component,area:area,itemid:itemid}},{methodname:"core_customfield_reload_template",args:{component:component,area:area,itemid:itemid}}]);promises[0].then((function(response){return categoryid=response,null})).catch(Notification.exception),promises[1].then((function(response){return Templates.render("core_customfield/list",response)})).then((function(html,js){return Templates.replaceNode($('[data-region="list-page"]'),html,js),window.location.href="#category-"+categoryid,null})).catch(Notification.exception),Promise.all(promises).then(pendingPromise.resolve).catch()}(component,area,itemid)}));var categoryName=function(element){return element.closest("[data-category-id]").find("[data-inplaceeditable][data-itemtype=category][data-component=core_customfield]").attr("data-value")};new SortableList($("#customfield_catlist .categorieslist"),{moveHandlerSelector:".movecategory [data-drag-type=move]"}).getElementName=function(el){return $.Deferred().resolve(categoryName(el))},$("[data-category-id]").on("sortablelist-drop",(function(evt,info){if(info.positionChanged){var pendingPromise=new Pending("core_customfield/form:categoryid:on:sortablelist-drop");Ajax.call([{methodname:"core_customfield_move_category",args:{id:info.element.data("category-id"),beforeid:info.targetNextElement.data("category-id")}}])[0].then(pendingPromise.resolve).catch(Notification.exception)}evt.stopPropagation()})),new SortableList($("#customfield_catlist .fieldslist tbody"),{moveHandlerSelector:".movefield [data-drag-type=move]"}).getDestinationName=function(parentElement,afterElement){return afterElement.length?afterElement.attr("data-field-name")?Str.get_string("afterfield","customfield",afterElement.attr("data-field-name")):$.Deferred().resolve(""):Str.get_string("totopofcategory","customfield",categoryName(parentElement))},$("[data-field-name]").on("sortablelist-drop",(function(evt,info){if(evt.stopPropagation(),info.positionChanged){var pendingPromise=new Pending("core_customfield/form:fieldname:on:sortablelist-drop");Ajax.call([{methodname:"core_customfield_move_field",args:{id:info.element.data("field-id"),beforeid:info.targetNextElement.data("field-id"),categoryid:Number(info.targetList.closest("[data-category-id]").attr("data-category-id"))}}])[0].then(pendingPromise.resolve).catch(Notification.exception)}})),$("[data-field-name]").on("sortablelist-drag",(function(evt){var pendingPromise=new Pending("core_customfield/form:fieldname:on:sortablelist-drag");evt.stopPropagation(),Str.get_string("therearenofields","core_customfield").then((function(s){return $("#customfield_catlist .categorieslist").children().each((function(){var fields=$(this).find($(".field")),nofields=$(this).find($(".nofields"));fields.length||nofields.length||$(this).find("tbody").append('<tr class="nofields"><td colspan="5">'+s+"</td></tr>"),fields.length&&nofields.length&&nofields.remove()})),null})).then(pendingPromise.resolve).catch(Notification.exception)})),$("[data-category-id], [data-field-name]").on("sortablelist-dragstart",(function(evt,info){setTimeout((function(){$(".sortable-list-is-dragged").width(info.element.width())}),501)}))}}}));

//# sourceMappingURL=form.min.js.map